#!/bin/bash
# Import 1.0a (tested on Glftpd 1.28) by FRSoldier
# Script to Import Linux Apache Backups or others home user dirs.
# 
# Puts all your ~user dir in .tar.bz2 format in a dir inside /glftpd/site,
# In old my system /home/users* it's the same dir like the Apache ServerName's 
# DocumentRoot.
# You need only to write the login name and password.
# After that the script will check if exists a backup for the user and will install
# the new locations. 
#
# In my case a file like 'user22.tar.bz2' extract to ./home/user22/*
# every tar.bz2 file has this folder: /home/userxx/
#
# I wrote this little script to import all my 400 users from my ncftpd system to
# Glftpd service.
#
# 28/01/03:
# - Fixed a small bug cause by wrong grep command
# - Corrected a syntax problem when checking the tar file
# - Tested the script in a server with 400 different users!
#
# ****************************************************************************
#
# Setup here your glftpd password
supreme="xxxxxx"
#
# Of course your path
glftpd="/home/glftpd"
#
# Dir where I have the backups (*.tar.bz2) in /${glftpd}/site/
disks="supermicro"

echo "Welcome, Tell me the User: " | tr -d '\n'
read utente 

if test -e ${glftpd}/site/${disks}/${utente}.tar.bz2; then
  echo "Backup on disk..."
  ls -l ${glftpd}/site/${disks}/${utente}.tar.bz2
else
  echo "I can't find the backups to use. Try Again. Exiting."
  exit 1
fi

echo "${utente} OK, type the password now: " | tr -d '\n'
read pwd2

echo "Setting Up User in Glftpd..."
ftp -n 127.0.0.1 <<EOF
user glftpd ${supreme} 
site adduser ${utente} ${pwd2} *@*
site change ${utente} homedir /site/${utente}
EOF

echo "Glftpd User Added... Checking the UID..."
uidz=`cat ${glftpd}/etc/passwd | grep "^${utente}:" | cut -f 3 -d ":"`

if test -n ${uidz}; then
  echo "UID found!"
else
  echo "Unable to Retrive an UID. Glftpd didn't accept your new user. Check and Retry."
  echo "Exiting."
  exit 1
fi

echo "Moving home to /site dir..."
mv ${glftpd}/site/${disks}/${utente}.tar.bz2 ${glftpd}/site/
bunzip2 ${glftpd}/site/${utente}.tar.bz2
if test -e ${glftpd}/site/${utente}.tar; then
  echo "Bunzip ran as well... let's untar..."
  tar xvf ${glftpd}/site/${utente}.tar
else
  echo "Check your bz2 file... it has problems"
  exit 1
fi

mv ${glftpd}/site/home/${utente} ${glftpd}/site/
sleep 1
if test -d ${glftpd}/site/${utente}; then
  rm -r ${glftpd}/site/${utente}.tar
  echo "Old Tar Deleted..."
fi

echo "Setting Up UID..."
chown -R ${uidz}:users ${glftpd}/site/${utente}

if test -d ${glftpd}/site/${utente}; then
  echo "Import Done, good for you!"
else
  echo "Something of weird it's happened, check your bz2 or tar backup!"
fi
